#ifndef OURDREAM_2D_MEDIASYSTEM_H
#define OURDREAM_2D_MEDIASYSTEM_H

#include "IInterface.h"
#include "ComDef.h"

class ISoundSystem : public IInterface
{
public:	
	virtual bool CALL AddSound(int ID, LPSTR soundfile, float X, float Y, float Z, int numRepeats)=0;
	virtual void CALL DelSound(int ID)=0;
	virtual void CALL DelAllSound(void)=0;
	virtual bool CALL SetupSoundParameters(int ID, float dopplerFactor, float rolloffFactor, float minDist, float maxDist)=0;
	
	virtual void CALL SetVolume(int ID, long volume)=0;
	virtual long CALL GetVolume(int ID)=0;
	
	virtual void CALL Play(int ID)=0;
	virtual bool CALL IsPlay(int ID)=0;
	virtual void CALL UpdateSoundPosition(int ID, float x, float y, float z)=0;
	virtual void CALL Stop(int ID)=0;
	virtual void CALL Release(void)=0;
};

struct SMediaInfo
{
	int m_iID;
	long m_lBitRate;
	long m_lHeight;
	long m_lWidth;
	double m_dLong;
	
	void Init(void)
	{
		m_iID=0;
		m_lBitRate=0;
		m_lHeight=0;
		m_lWidth=0;
		m_dLong=0;
	}
};

class IMediaSystem : public IInterface
{
public:
	virtual bool CALL Init(SOD2DSystemSetup setup)=0;
	virtual void CALL Release(void)=0;
	
	virtual bool CALL AddMedia(int ID, LPCWSTR file, SOD2DFloatRect position)=0;
	virtual void CALL DelMedia(int ID)=0;
	virtual void CALL DelAllMedia(void)=0;
	
	virtual bool CALL Play(int ID)=0;
	virtual void CALL Pause(int ID)=0;
	virtual void CALL Stop(int ID)=0;
	
	virtual void CALL OnEvent(void)=0;
	
	virtual void CALL GetMediaInfo(int ID, SMediaInfo * info)=0;
	virtual bool CALL IsPlay(int ID)=0;
	virtual void CALL SetMediaVolume(int ID, long volume)=0;
	virtual long CALL GetMediaVolume(int ID)=0;
	virtual void CALL SetMediaPosition(int ID, double second)=0;
	virtual double CALL GetMediaPosition(int ID)=0;
	
};

#endif